<?php #CodeGenerator Δ 692b657a8d97bc9d5f0f53ebf8dd81f6 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-28 04:11:57
 * @package     bplan-base/globals
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Models;


use BplanBase\Globals\Observers\TenantObserver;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasNoInternalScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.5.0 / 2025-06-28
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([TenantObserver::class])]
class Tenant extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasNoInternalScope;
    use HasOrderedScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $casts = [
        'active'     => 'boolean',
        'created_at' => 'datetime',
        'deleted_at' => 'datetime',
        'internal'   => 'boolean',
        'updated_at' => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $fillable = [
        'active',
        'identifier',
        'internal',
        'master_id',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
        'uuid',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'tenants';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      BelongsToMany
     *
     * @version     1.0.1 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function assignedUsers(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'tenant_user', 'tenant_id', 'user_id')->withPivot('access_level', 'created_at', 'updated_at', 'uuid');

    } // assignedUsers()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function entityTypes(): HasMany
    {
        return $this->hasMany(EntityType::class, 'tenant_id');

    } // entityTypes()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function externalSystems(): HasMany
    {
        return $this->hasMany(TenantExternalSystem::class, 'tenant_id');

    } // externalSystems()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function importLogs(): HasMany
    {
        return $this->hasMany(ImportLog::class, 'tenant_id');

    } // importLogs()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function locales(): HasMany
    {
        return $this->hasMany(TenantLocale::class, 'tenant_id');

    } // locales()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function masterTenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class, 'master_id');

    } // masterTenant()


    /**
     *
     * @return      BelongsToMany
     *
     * @version     1.0.1 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function modules(): BelongsToMany
    {
        return $this->belongsToMany(Module::class, 'module_tenant', 'tenant_id', 'module_id')->withPivot('active', 'created_at', 'updated_at', 'uuid');

    } // modules()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function roles(): HasMany
    {
        return $this->hasMany(Role::class, 'tenant_id');

    } // roles()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function subTenants(): HasMany
    {
        return $this->hasMany(Tenant::class, 'master_id');

    } // subTenants()


    /**
     *
     * @return      HasOne
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function tenantRecord(): HasOne
    {
        return $this->hasOne(TenantRecord::class, 'id');

    } // tenantRecord()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class, 'tenant_id');

    } // users()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Tenant extends Model {}
