<?php
/**
 * Global Configuration
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Config
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

return [
    'anonymization-threshold-days' => env('ANONYMIZATION_THRESHOLD_DAYS', 30),
    'api' => [
        'default-client' => env('API_DEFAULT_CLIENT', null),
        'log-level' => env('API_LOG_LEVEL', false),
    ],
    'db' => [
        'sql-logging' => env('DB_SQL_LOGGING', false),
    ],
    'dev' => [
        'seeder-create-user' => env('DEV_SEEDER_CREATE_USER', 'system@bplan-solutions.de'),
    ],
    'global-tenant' => env('GLOBAL_TENANT', null),

    'paginate' => [
        'per-page' => 12,
    ],
    'paths' => [
        'apache-binary' => env('PATH_APACHE_BINARY', '/.server/xampp/apache/bin/httpd.exe'),
        'php-binary' => env('PATH_PHP_BINARY', '/.server/bin/php/8.3.1/php-cgi.exe'),
    ],
    'system-locales' => [
        'de',
        'en',
        'fr',
        'it',
    ],

];
