<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/web-io-connector
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\Country;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\TenantRecord;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantRecordSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (TenantRecord::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            $Country = Country::where('iso3166_alpha_2', '=', 'DE')->first();
            $Tenant = Tenant::where('identifier', 'System')->first();

            TenantRecord::insert([
                [
                    'id' => $Tenant->id,
                    'uuid' => $Tenant->uuid,
                    'created_at' => $date,
                    'updated_at' => $date,
                    'city' => 'Köln',
                    'company' => 'bplan-solutions GmbH & Co. KG',
                    'country_id' => $Country->id,
                    'description' => NULL,
                    'email' => 'core@bplan-solutions.de',
                    'home_page' => 'https://www.bplan-solutions.de/',
                    'house_number' => '22',
                    'phone_number' => '22039898980',
                    'phone_number_country_code' => '+49',
                    'short_name' => 'bplan-solutions',
                    'street' => 'Max-Reichpietsch-Strasse',
                    'zip_code' => '51147',
                ],
            ]);

        }
    } // run()

} // class TenantRecordSeeder extends Seeder {}
