@props(['disabled' => false, 'label' => null, 'active' => true, 'mandatory' => false, 'readonly' => false])

<div x-show="{{ $active ? 'true' : 'false' }}">
    @if (!empty($label))
        <div class="flex items-center">
            <x-label :for="$attributes['id']" :value="$label" />
            @if ($mandatory)
                <span class="text-red-500">*</span>
            @endif
        </div>
    @endif
    <input {{$readonly ? 'readonly' : ''}} {{ $disabled ? 'disabled' : '' }} {!! $attributes->merge([
        'class' =>
            'border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-primary-500 dark:focus:border-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 rounded-md shadow-sm',
    ]) !!}>

    <x-input-error :for="$attributes['wire:model']" />
</div>
