{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Templates
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
--}}

{{--

 @var       Model $MainObject

 @var       string $modelClass

 @var       string $resourceName

 @var       string $serviceClass

--}}

@php

    $key = 'grid-'.now()->timestamp.'-'.$resourceName;
    $params = [
        'Collection' => $Collection,
        'modelClass' => $modelClass ?? null,
        'resourceName' => $resourceName,
        'serviceClass' => $serviceClass,
    ];

@endphp

    <x-app-layout>

      <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('globals::core-'.$resourceName.'.page.heading', ['resourcename' => ucwords($resourceName)]) }}
        </h2>
      </x-slot>

      <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
          <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">

@livewire($componentClass, $params, $key)

          </div>
        </div>
      </div>

    </x-app-layout>
