{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Templates
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
--}}

          <div class="grid grid-cols-6 sm:grid-cols-6 gap-6 min-w-full pl-6 pr-6 p-4">

            <div class="col-span-3 sm:col-span-3 flex items-center text-sm"></div>
            <div class="col-span-3 sm:col-span-3">
              <div class="flex justify-end">
                <a href="{!! route($this->getRedirectRoute('Abort'), $this->getRedirectParameters('Abort')) !!}">
                  <button class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" type="button">{!! __('globals::global.action.back') !!}</button>
                </a>

@if ($readOnly === false)
    @php
        $createParams = [
            'tenant_id' => $mainID,
            'redirect-to' => [
                'a|c|d|u' => [
                    'id-name' => 'tenant-module-id',
                    'params' => [
                        'id' => $mainID,
                        'tab' => 'tenant-modules',
                    ],
                    'route' => 'tenant',
                ],
            ],
        ];
    @endphp

                <a href="{!! route('create.tenant-module', $createParams) !!}">
                  <button class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500" type="button">{!! __('globals::global.action.create') !!}</button>
                </a>

@endif

              </div>
            </div>

          </div>
