<?php
/**
 * Base Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Foundation\Repositories;


use BplanBase\Globals\Helpers\QueryHelper;
use Closure;
use Illuminate\Database\Eloquent\Builder;


/**
 * Base Repository Class
 *
 * @version     1.0.0 / 2025-08-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseIndexCollectionRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Builder|Closure|null $ExtendQuery
     *
     * @param       Builder $Query
     *
     * @version     1.0.0 / 2025-08-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _extendQuery(Builder|Closure|null $ExtendQuery, Builder $Query)
    {
        if ($ExtendQuery !== null) {
            /*
            **  Erweiterte Bedingungen (Filter-/Such-Parameter) anwenden. */
            if ($ExtendQuery instanceof Builder) {
                $Query = QueryHelper::applyConditionsFromBuilder($ExtendQuery, $Query);

            } elseif ($ExtendQuery instanceof Closure) {
                $Query = $ExtendQuery($Query);
            }
        }
        return $Query;

    } // _extendQuery()


} // class BaseIndexCollectionRepository {}
