<?php
/**
 * Repository Class
 *
 * @todo        Standardfilter (active, internal) fix machen und überflüssige Parameter entfernen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories;


use BplanBase\Globals\Foundation\Repositories\BaseIndexCollectionRepository;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\ValueObjects\PaginateArgs;
use Closure;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;


/**
 * Repository Class
 *
 * @version     1.0.0 / 2025-08-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class IndexCollectionRepository extends BaseIndexCollectionRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       Builder|Closure|null $ExtendQuery
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       array|bool|int $paginate
     *              Can be either the number of elements, TRUE or an array. If
     *              TRUE is passed, the default number from the configuration is
     *              used. If an array is passed, then all known arguments for
     *              paginate() (columns, page, pageName, perPage, total) can be
     *              specified in it (all optional).
     *              @see https://api.laravel.com/docs/12.x/Illuminate/Database/Eloquent/Builder.html#method_paginate
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @param       bool $withInternal
     *              By default, only the data records marked as “internal = 0” are read out. By
     *              setting this parameter to TRUE, the internal status is ignored and all data
     *              records are read.
     *
     * @return      Collection|LengthAwarePaginator<Model>
     *
     * @version     1.0.0 / 2025-08-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getUsers(Builder|Closure|null $ExtendQuery = null, array|string|null $orderBy = null, array|bool|int $paginate = false, bool $withInactive = false, bool $withInternal = false): Collection|LengthAwarePaginator
    {
        $Query = User::query();

        if ($withInactive === false) {
            $Query->active();
        }
        if ($withInternal === false) {
            $Query->where('internal', '=', 0);
        }
        $Query = self::_extendQuery($ExtendQuery, $Query);

        if ($orderBy === null) {
            $orderBy = 'id';
        }
        $Query->ordered($orderBy);

        $PaginateArgs = PaginateArgs::from($paginate);

        return $Query->paginate(...$PaginateArgs->toArray());

    } // getUsers()


} // class IndexCollectionRepository extends BaseIndexCollectionRepository {}
