<?php
/**
 * Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-15 00:00:00
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories;


use BplanBase\Globals\Foundation\Repositories\BaseRepository;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Repositories\Core\TenantRepository as CoreTenantRepository;
use BplanBase\Globals\ValueObjects\PaginateArgs;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\LengthAwarePaginator;


/**
 * Repository Class
 *
 * @version     4.6.0 / 2025-07-16
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantRepository extends BaseRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass = Tenant::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the
     *              method cache already contains a suitable entry. The storage of
     *              a value in the method cache is not affected by this parameter.
     *
     * @param       bool $ignoreRestriction
     *              By default, the result is limited to the tenants of the current user. The
     *              restriction can be removed by setting this parameter to TRUE.
     *
     * @param       array|string|null $orderBy
     *              @see BplanBase\Globals\Helpers\QueryHelper::applyOrderBy() for
     *              details.
     *
     * @param       array|bool|int $paginate
     *              Can be either the number of elements, TRUE or an array. If
     *              TRUE is passed, the default number from the configuration is
     *              used. If an array is passed, then all known arguments for
     *              paginate() (columns, page, pageName, perPage, total) can be
     *              specified in it (all optional).
     *              @see https://api.laravel.com/docs/12.x/Illuminate/Database/Eloquent/Builder.html#method_paginate
     *
     * @param       Builder|null $Query
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By
     *              setting this parameter to TRUE, the inactive data records can
     *              also be read out.
     *
     * @param       bool $withInternal
     *              By default, only the data records marked as "internal = 0" are read out. By
     *              setting this parameter to TRUE, the internal status is ignored and all data
     *              records are read.
     *
     * @return      Collection|LengthAwarePaginator<Model>
     *
     * @version     5.1.0 / 2025-07-16
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, bool $ignoreRestriction = false, array|string|null $orderBy = null, array|bool|int $paginate = false, Builder|null $Query = null, bool $withInactive = false, bool $withInternal = false): Collection|LengthAwarePaginator
    {
        static $cache = [];

        $cacheKey = md5(json_encode(func_get_args()));

        if ($paginate !== false) {
            $ignoreCache = true;
        }
        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = self::_resolveQuery($Query);

        if ($ignoreRestriction === false) {
            $AuthUser = auth()->user();
            /*
            **  Hier wird bewusst nicht mit der Liste der Tenants aus der Registry gearbeitet, weil im
            **  Falle einer Änderung nicht sichergestellt ist, dass diese Liste zum Zeitpunkt der Abfrage
            **  auf dem aktuellen Stand ist. */
            $userTenants = CoreTenantRepository::determineUserTenants($AuthUser, ignoreRestriction: $ignoreRestriction);

            $Query->whereIn('id', array_keys($userTenants));
        }
        if ($withInactive === false) {
            $Query->active();
        }
        if ($withInternal === false) {
            $Query->noInternal();
        }
        $Query->ordered($orderBy);

        if ($paginate === false) {
            return $cache[$cacheKey] = $Query->get();
        }
        $PaginateArgs = PaginateArgs::from($paginate);

        return $Query->paginate(...$PaginateArgs->toArray());

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $ignoreRestriction
     *              By default, the result is limited to the tenants of the current user. The
     *              restriction can be removed by setting this parameter to TRUE.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      Tenant|null
     *
     * @version     3.1.0 / 2025-07-16
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $ignoreRestriction = false, bool $returnOrFail = true): Model|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = self::_resolveQuery();

        if ($ignoreRestriction === false) {
            $AuthUser = auth()->user();
            /*
            **  Hier wird bewusst nicht mit der Liste der Tenants aus der Registry gearbeitet, weil im
            **  Falle einer Änderung nicht sichergestellt ist, dass diese Liste zum Zeitpunkt der Abfrage
            **  auf dem aktuellen Stand ist. */
            $userTenants = CoreTenantRepository::determineUserTenants($AuthUser, ignoreRestriction: $ignoreRestriction);

            $Query->whereIn('id', array_keys($userTenants));
        }
        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->find($id);
        }
        return $cache[$cacheKey] = $Query->findOrFail($id);

    } // getById()


    /**
     * Returns the model instance for the given UUID
     *
     * @param       string $uuid
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $ignoreRestriction
     *              By default, the result is limited to the tenants of the current user. The
     *              restriction can be removed by setting this parameter to TRUE.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      Tenant|null
     *
     * @version     2.2.0 / 2025-07-16
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByUuid(int|string $uuid, bool $ignoreCache = false, bool $ignoreRestriction = false, bool $returnOrFail = true): Model|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::where('uuid', '=', $uuid);

        if ($ignoreRestriction === false) {
            $AuthUser = auth()->user();
            /*
            **  Hier wird bewusst nicht mit der Liste der Tenants aus der Registry
            **  gearbeitet, weil im Falle einer Änderung nicht sichergestellt ist,
            **  dass diese Liste zum Zeitpunkt der Abfrage auf dem aktuellen Stand
            **  ist. */
            $userTenants = CoreTenantRepository::determineUserTenants($AuthUser, ignoreRestriction: $ignoreRestriction);

            $Query->whereIn('id', array_keys($userTenants));
        }
        if ($returnOrFail === true) {
            return $cache[$cacheKey] = $Query->first();
        }
        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getByUuid()


} // class TenantRepository extends BaseRepository {}
