<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\EntityTypes;


use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeModel;
use BplanBase\Globals\Models\Module;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class IndividualSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $Tenant = Tenant::where('identifier', '=', 'System')->first();
        $Model = EntityTypeModel::where('identifier', '=', 'Individual')->first();
        $Module = Module::where('identifier', '=', 'Core')->first();

        EntityType::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'abstract' => 1,
                'identifier' => 'Individual',
                'labels' => '{"de": "Personen", "en": "Persons"}',
                'main_type' => 'Individual',
                'master_id' => null,
                'model_id' => $Model->id,
                'module_id' => $Module->id,
                'private' => 0,
                'resource_name' => 'individuals',
                'tenant_id' => $Tenant->id,
            ],

        ]);

    } // run()

} // class IndividualSeeder extends Seeder {}
