<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use App\Models\User;
use BplanBase\Globals\Models\UserRecord;
use BplanBase\Globals\Repositories\UserRecordRepository;
use BplanBase\Globals\Repositories\UserRepository;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserRecordSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
		$date = date('Y-m-d H:i:s');
        /*
        **  Spezielle Arbeitsweise
        **  Es werden die bereits angelegten User ermittelt um daraus UserRecord-Datensätze zu erstellen. */
		$Users = User::get();

		$insertUserRecords = [];

		if (!$Users->isEmpty()) {
			foreach ($Users as $User) {
				if (UserRecordRepository::getById($User->id) !== null) {
					continue;
				}
				$name = explode(' ', $User->name, 2);

				$insertUserRecords[] = [
					'id' => $User->id,
					'uuid' => $User->uuid,
					'created_at' => $date,
					'updated_at' => $date,
					'email' => $User->email,
					'first_name' => ucfirst($name[0]),
					'last_name' => $name[1] ?? 'User',
				];
			}
		}
		UserRecord::insert($insertUserRecords);

    } // run()

} // class UserRecordSeeder extends Seeder {}
