@props(['imageUrl' => null, 'imageRounded' => true])

<span id="badge-dismiss-default"
    class="inline-flex items-center px-2 py-1 text-xs font-medium rounded me-1 text-primary-800 bg-primary-100 dark:bg-primary-900 dark:text-primary-300">
    @if (!empty($imageUrl))
        <img src="{{ $imageUrl }}" class="{{ $imageRounded ? 'rounded-full size-8' : 'rounded-none h-8'}} object-center p-0.5 me-2 shadow bg-white" />
    @endif
    {{ $label }}
    @if ($isDeleteable)
        <button type="button"
            wire:click="toggleComboBoxDataItem(@js($itemsKey), @js($index))"
            class="inline-flex items-center p-1 text-sm bg-transparent rounded-sm ms-2 text-primary-400 hover:bg-primary-200 hover:text-primary-900 dark:hover:bg-primary-800 dark:hover:text-primary-300"
            data-dismiss-target="#badge-dismiss-default" aria-label="Remove">
            <svg class="w-2 h-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                viewBox="0 0 14 14">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
            </svg>
        </button>
    @endif
</span>
