<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Foundation\Http\Controllers\CoreController;
use BplanBase\Globals\Livewire\Core\Tenants\Form as TenantForm;
use BplanBase\Globals\Livewire\Core\Tenants\Grid as TenantGrid;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Repositories\Core\TenantRepository;
use BplanBase\Globals\Services\TenantService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     2.0.0 / 2025-06-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantController extends CoreController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = TenantForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = TenantGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = Tenant::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = TenantRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'tenants';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       TenantService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, TenantService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantController extends CoreController {}
