<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Core\Global;


use BplanBase\Globals\Enums\CaseStyle;
use BplanBase\Globals\Enums\Number;
use BplanBase\Globals\Helpers\StringHelper;
use BplanBase\Globals\Registries\Registry;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Str;
use Livewire\Component;


/**
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseGrid extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $activeStatus
     */
    public $activeStatus = [
        0 => '
                <svg class="h-6 w-6  text-red-500" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                  <path d="M15 12H9m12 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" stroke-linecap="round" stroke-linejoin="round" />
                </svg>',
        1 => '
                <svg class="h-6 w-6 text-green-500" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                  <path d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" stroke-linecap="round" stroke-linejoin="round" />
                </svg>',
    ];


    /**
     * @var     array|Collection $Collection
     */
    public $Collection;


    /**
     * @var     array|null $createParams
     */
    public $createParams;


    /**
     * @var     string $highlightID
     */
    public $highlightID;


    /**
     *
     * @var     string $lc
     */
    public $lc;


    /**
     *
     * @var     string $localeFile
     */
    public $localeFile;


    /**
     * @var     string $modelClass
     */
    public $modelClass;


    /**
     * @var    bool $readOnly
     */
    public $readOnly = false;


    /**
     * @var     string $resourceGroup
     */
    public $resourceGroup;


    /**
     * @var     string $resourceName
     */
    public $resourceName;


    /**
     * @var     string $resourceNameSingular
     */
    public $resourceNameSingular;


    /**
     * @var     string $selectedTab
     */
    public $selectedTab;


    /**
     * @var     array $tabs
     */
    public $tabs = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initTabs(): void
    {
        if (!empty($this->tabs)) {
            $tabs = $this->tabs;
            $this->tabs = [];

            foreach ($tabs as $tab) {
                $this->tabs[$tab] = [
                    'active' => true,
                    'identifier' => $tab,
                    'label' => __('globals::'.$this->localeFile.'.tab-name.'.$tab),
                    'view' => $tab,
                ];
            }
        }
    } // _initTabs()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processQueryParameters(): void
    {
        $Request = request();

        if ($Request->has('highlight.'.$this->resourceGroup.'-id')) {
            $this->highlightID = trim($Request->input('highlight.'.$this->resourceGroup.'-id'));
        }
        if ($Request->has('tab')) {
            $this->selectedTab = trim($Request->input('tab'));
        }
    } // _processQueryParameters()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount(): void
    {
        $this->lc = config('app.locale');
        $this->resourceGroup = Str::singular($this->resourceName);

        // if ($this->resourceGroup === null) {
        //     $this->resourceGroup = $this->resourceName;
        // }
        $this->localeFile = 'core-'.StringHelper::reformat($this->resourceName, CaseStyle::Slug, Number::Plural);
        $this->resourceNameSingular = StringHelper::reformat($this->resourceName, Number: Number::Singular);

        $this->_processQueryParameters();
        $this->_initTabs();

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.core.'.$this->resourceName.'.grid');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BaseGrid extends Component {}
