<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Forms;


use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Http\Requests\Individuals\StoreRequest;
use BplanBase\Globals\Http\Requests\Individuals\UpdateRequest;
use BplanBase\Globals\Models\Individual;
use BplanBase\Globals\Repositories\EntityTypeRepository;
use BplanBase\Globals\Services\IndividualService;
use Livewire\Form;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-08-07
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class IndividualForm extends Form
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean
     */
    public bool $active = true;


    /**
     * @var     string|null
     */
    public ?string $company = null;


    /**
     * @var     boolean
     */
    public bool $contact = false;


    /**
     * @var     string|null
     */
    public ?string $contact_group = null;


    /**
     * @var     string|null
     */
    public ?string $cost_center = null;


    /**
     * @var     string|null
     */
    public ?string $date_of_birth = null;


    /**
     * @var     string|null
     */
    public ?string $date_of_entry = null;


    /**
     * @var     string|null
     */
    public ?string $department = null;


    /**
     * @var     string|null
     */
    public ?string $email = null;


    /**
     * @var     boolean
     */
    public bool $emergency_contact = false;


    /**
     * @var     string|null
     */
    public ?string $entity_type_id = null;


    /**
     * @var     string|null
     */
    public ?string $first_name = null;


    /**
     * @var     string|null
     */
    public ?string $form_of_address = null;


    /**
     * @var     string|null
     */
    public ?string $function = null;


    /**
     * @var     string|null
     */
    public ?string $gender = null;


    /**
     * @var     boolean
     */
    public bool $global_contact = false;


    /**
     * @var     string|null
     */
    public ?string $id_number = null;


    /**
     * @var     Individual|null
     */
    public ?Individual $individual;


    /**
     * @var     IndividualService
     */
    protected IndividualService $individualService;


    /**
     * @var     string|null
     */
    public ?string $job_title = null;


    /**
     * @var     string|null
     */
    public ?string $last_name = null;


    /**
     * @var     string|null
     */
    public ?string $mobile_phone_number = null;


    /**
     * @var     string|null
     */
    public ?string $mobile_phone_number_country_code = null;


    /**
     * @var     string|null
     */
    public ?string $mobile_phone_number_full = null;


    /**
     * @var     string|null
     */
    public ?string $organizational_unit = null;


    /**
     * @var     string|null
     */
    public ?string $personnel_number = null;


    /**
     * @var     string|null
     */
    public ?string $phone_number = null;


    /**
     * @var     string|null
     */
    public ?string $phone_number_country_code = null;


    /**
     * @var     string|null
     */
    public ?string $phone_number_full = null;


    /**
     * @var     string|null
     */
    public ?string $user_id = null;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-07
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function boot(IndividualService $individualService)
    {
        $this->individualService = $individualService;
        $this->entity_type_id = EntityType::where('identifier', '=', 'Individual.Employee')
            ->first()->id;

    } // boot()


    /**
     *
     * @return      Individual
     *
     * @version     1.0.0 / 2025-08-07
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function create(): Individual
    {
        $this->validate();

        $individual = $this->individualService->create([
            'active' => $this->active,
            'company' => $this->company,
            'contact' => $this->contact,
            'contact_group' => $this->contact_group,
            'cost_center' => $this->cost_center,
            'date_of_birth' => $this->date_of_birth,
            'date_of_entry' => $this->date_of_entry,
            'department' => $this->department,
            'email' => $this->email,
            'emergency_contact' => $this->emergency_contact,
            'entity_type_id' => $this->entity_type_id,
            'first_name' => $this->first_name,
            'form_of_address' => $this->form_of_address,
            'function' => $this->function,
            'gender' => $this->gender,
            'global_contact' => $this->global_contact,
            'id_number' => $this->id_number,
            'job_title' => $this->job_title,
            'last_name' => $this->last_name,
            'mobile_phone_number' => $this->mobile_phone_number,
            'mobile_phone_number_country_code' => $this->mobile_phone_number_country_code,
            'mobile_phone_number_full' => $this->mobile_phone_number_full,
            'organizational_unit' => $this->organizational_unit,
            'personnel_number' => $this->personnel_number,
            'phone_number' => $this->phone_number,
            'phone_number_country_code' => $this->phone_number_country_code,
            'phone_number_full' => $this->phone_number_full,
            'user_id' => $this->user_id,
        ]);
        return $individual;

    } // create()


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-07
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function delete(): void
    {
        $this->individualService->delete($this->individual);

    } // delete()


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-08-07
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function rules()
    {
        $id = $this->individual?->id ?? null;
        $rules = [];

        if (!empty($id)) {
            $rules = UpdateRequest::getRules($id);

        } else {
            $rules = StoreRequest::getRules();
        }
        return $rules;

    } // rules()


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-07
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function setIndividual(Individual $individual)
    {
        $this->individual = $individual;

        $this->active = $individual->active ?? false;
        $this->company = $individual->company;
        $this->contact = $individual->contact ?? false;
        $this->contact_group = $individual->contact_group;
        $this->cost_center = $individual->cost_center;
        $this->date_of_birth = $individual->date_of_birth;
        $this->date_of_entry = $individual->date_of_entry;
        $this->department = $individual->department;
        $this->email = $individual->email;
        $this->emergency_contact = $individual->emergency_contact ?? false;
        $this->entity_type_id = $individual->entity_type_id;
        $this->first_name = $individual->first_name;
        $this->form_of_address = $individual->form_of_address;
        $this->function = $individual->function;
        $this->gender = $individual->gender;
        $this->global_contact = $individual->global_contact ?? false;
        $this->id_number = $individual->id_number;
        $this->job_title = $individual->job_title;
        $this->last_name = $individual->last_name;
        $this->mobile_phone_number = $individual->mobile_phone_number;
        $this->mobile_phone_number_country_code = $individual->mobile_phone_number_country_code;
        $this->mobile_phone_number_full = $individual->mobile_phone_number_full;
        $this->organizational_unit = $individual->organizational_unit;
        $this->personnel_number = $individual->personnel_number;
        $this->phone_number = $individual->phone_number;
        $this->phone_number_country_code = $individual->phone_number_country_code;
        $this->phone_number_full = $individual->phone_number_full;
        $this->user_id = $individual->user_id;

    } // setIndividual()


    /**
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-08-07
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function update(): bool
    {
        $this->validate();

        $this->individualService->update($this->individual, [
            'active' => $this->active,
            'company' => $this->company,
            'contact' => $this->contact,
            'contact_group' => $this->contact_group,
            'cost_center' => $this->cost_center,
            'date_of_birth' => $this->date_of_birth,
            'date_of_entry' => $this->date_of_entry,
            'department' => $this->department,
            'email' => $this->email,
            'emergency_contact' => $this->emergency_contact,
            'entity_type_id' => $this->entity_type_id,
            'first_name' => $this->first_name,
            'form_of_address' => $this->form_of_address,
            'function' => $this->function,
            'gender' => $this->gender,
            'global_contact' => $this->global_contact,
            'id_number' => $this->id_number,
            'job_title' => $this->job_title,
            'last_name' => $this->last_name,
            'mobile_phone_number' => $this->mobile_phone_number,
            'mobile_phone_number_country_code' => $this->mobile_phone_number_country_code,
            'mobile_phone_number_full' => $this->mobile_phone_number_full,
            'organizational_unit' => $this->organizational_unit,
            'personnel_number' => $this->personnel_number,
            'phone_number' => $this->phone_number,
            'phone_number_country_code' => $this->phone_number_country_code,
            'phone_number_full' => $this->phone_number_full,
            'user_id' => $this->user_id,
        ]);
        return true;

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class IndividualForm extends Form {}
