<?php
/**
 * AppLog Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Logging
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Logging;


use Illuminate\Support\Facades\Log;
use Stringable;


/**
 * AppLog Class
 *
 * @version     1.0.0 / 2025-08-03
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class AppLog
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       string|null $prefix
     *
     * @return      string|Stringable
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private static function _prefix(string|Stringable $message, string|null $prefix): string|Stringable
    {
        if (empty($prefix)) {
            return $message;
        }
        return '['.$prefix.'] '.$message;

    } // _prefix()


    /**
     *
     * @param       array|string $context
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private static function _prepareContext(array|string $context): array
    {
        if (is_array($context)) {
            return $context;
        }
        return (array) trim($context);

    } // _prepareContext()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function alert(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog-composite')->alert(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // alert()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function critical(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog-composite')->critical(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // critical()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function debug(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog')->debug(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // debug()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function emergency(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog-composite')->emergency(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // emergency()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function error(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog-composite')->error(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // error()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function info(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog')->info(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // info()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function notice(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog')->notice(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // notice()


    /**
     *
     * @param       string|Stringable $message
     *
     * @param       array|string $context
     *
     * @param       string|null $prefix
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function warning(string|Stringable $message, array|string $context = [], string|null $prefix = null): void
    {
        Log::channel('applog-composite')->warning(self::_prefix($message, $prefix), self::_prepareContext($context));

    } // warning()


} // class AppLog {}
