<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;

use BplanBase\Globals\Models\ExternalSystem;
use BplanBase\Globals\Models\Module;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ExternalSystemSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (ExternalSystem::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            ExternalSystem::insert([
                [
                    'uuid' => Str::uuid(),
                    'active' => 1,
                    'created_at' => $date,
                    'updated_at' => $date,
                    'label' => 'Active Directory',
                    'identifier' => 'AD',
                ], [
                    'uuid' => Str::uuid(),
                    'active' => 1,
                    'created_at' => $date,
                    'updated_at' => $date,
                    'label' => 'Azure Cloud',
                    'identifier' => 'Azure',
                ],

            ]);

        }
    } // run()

} // class ExternalSystemSeeder extends Seeder {}
