<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\TenantLocale;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantLocaleSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (TenantLocale::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            $Tenant = Tenant::where('identifier', 'System')->first();

            TenantLocale::insert([
                [
                    'uuid' => Str::uuid(),
                    'active' => 1,
                    'created_at' => $date,
                    'key_index' => 1,
                    'locale' => 'de',
                    'main' => 1,
                    'tenant_id' => $Tenant->id,
                ], [
                    'uuid' => Str::uuid(),
                    'active' => 1,
                    'created_at' => $date,
                    'key_index' => 2,
                    'locale' => 'en',
                    'main' => 0,
                    'tenant_id' => $Tenant->id,
                ], [
                    'uuid' => Str::uuid(),
                    'active' => 1,
                    'created_at' => $date,
                    'key_index' => 3,
                    'locale' => 'fr',
                    'main' => 0,
                    'tenant_id' => $Tenant->id,
                ],
            ]);

        }
    } // run()

} // class TenantLocaleSeeder extends Seeder {}
