{{--
 * Blade Template
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Blades
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
--}}

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    {{-- Critical theme script: runs before CSS to avoid flash --}}
    <script>

        (function() {
            try {
                const stored = localStorage.getItem('theme'); // 'dark' | 'light' | null

                if (stored === 'dark') {
                    document.documentElement.classList.add('dark');

                } else if (stored === 'light') {
                    document.documentElement.classList.remove('dark');

                } else {
                    // no stored preference -> respect system
                    const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;

                    if (prefersDark) {
                        document.documentElement.classList.add('dark');
                    }
                }
            } catch (e) {
                /* ignore */
            }
        })();

    </script>

    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net" />
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <!-- Styles -->
    @livewireStyles

  </head>
  <body class="bg-white dark:bg-gray-900 text-gray-900 dark:text-gray-100 font-sans antialiased">
    <x-banner />

    <div class="min-h-screen bg-gray-100 dark:bg-gray-900">

@include('globals::layouts.module-frame.sidebar')

      <div x-data="" class="p-4{!! !empty($currentModule) ? ' sm:ml-64' : '' !!}">

@if (isset($header))

          <!-- Page Heading -->
        <header class="bg-white shadow dark:bg-gray-800">
          <div class="px-4 py-6 mx-auto max-w-7xl sm:px-6 lg:px-8">
            {{ $header }}
          </div>
        </header>

@endif

        <!-- Page Content -->
        <main>
          <div class="container py-8 mx-auto sm:px-6 lg:px-8">
            {{ $slot }}
          </div>
        </main>
      </div>
    </div>

    @stack('modals')

    @livewireScripts

    <script>

        document.addEventListener('livewire:init', () => {
            tippy('[data-tippy-content]');

            flatpickr.localize(@js(app()->getLocale()));

            Livewire.on('init-tippyjs', () => {
                setTimeout(() => {
                    tippy('[data-tippy-content]');
                }, 250);
            });
        });

    </script>

    @stack('post-scripts')

  </body>
</html>
