<?php #CodeGenerator Δ 5348811d0348ef98e9c1fe41568bbfd3 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-07-04 15:07:23
 * @package     bplan-base/globals
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Models;


use BplanBase\Globals\Observers\LocationObserver;
use BplanBase\Globals\Registries\Registry;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.5.0 / 2025-07-04
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([LocationObserver::class])]
class Location extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasOrderedScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-07-04
     */
    protected $appends = [
        'label',
    ];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-07-04
     */
    protected $casts = [
        'active'     => 'boolean',
        'created_at' => 'datetime',
        'deleted_at' => 'datetime',
        'labels'     => 'object',
        'top_level'  => 'boolean',
        'updated_at' => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-07-04
     */
    protected $fillable = [
        'active',
        'address_addition',
        'city',
        'coordinates',
        'email',
        'house_number',
        'labels',
        'location_type_id',
        'master_id',
        'phone_number',
        'street',
        'top_level',
        'zip_code',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-07-04
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-07-04
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'locations';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      string|null
     *
     * @version     1.0.0 / 2025-07-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getLabelAttribute(): string|null
    {
        $fallback = config('app.fallback_locale');
        $locale = Registry::get('appLocale');

        return $this->labels->{$locale} ?? ($this->labels->{$fallback} ?? null);

    } // getLabelAttribute()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-07-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function locationType(): BelongsTo
    {
        return $this->belongsTo(LocationType::class, 'location_type_id');

    } // locationType()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-07-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function locations(): HasMany
    {
        return $this->hasMany(Location::class, 'master_id');

    } // locations()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-07-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function master(): BelongsTo
    {
        return $this->belongsTo(Location::class, 'master_id');

    } // master()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Location extends Model {}
