<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Dev;


use App\Models\User;
use BplanBase\Globals\Enums\UserAccessLevel;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Setup\Logger;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');
        $env = strtolower(config('app.env'));

        $Tenant = Tenant::where('identifier', 'System')->first();

        $users = [
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::Developer->name,
                'email' => 'wassilios.meletiadis@bplan-solutions.de',
                'internal' => 1,
                'name' => 'Wassilios Meletiadis',
                'restricted' => 0,
                'tenant_id' => $Tenant->id,
            ], [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::Developer->name,
                'email' => 'emilio.cannarozzo@bplan-solutions.de',
                'internal' => 1,
                'name' => 'Emilio Cannarozzo',
                'restricted' => 0,
                'tenant_id' => $Tenant->id,
            ],
        ];
        $outputs = [];
        $setupLog = '';

        foreach ($users as & $user) {
            if ($env === 'production') {
                $password = Str::random(12);
            } else {
                $password = 'Test!234';
            }
            if ($user['name'] === 'system') {
                $user['password'] = '';

            } else {
                $user['password'] = Hash::make($password);

                $outputs[] = [
                    'username' => $user['email'],
                    'password' => $password
                ];
                $setupLog .= $user['email'].'/'.$password.'\n';
            }
        }
        User::insert($users);

        $setupLog = [];

        foreach ($outputs as $output) {
            $setupLog[] = 'User: '.$output['username'].'/'.$output['password'];
        }
        Logger::log($setupLog, __FILE__);

    } // run()


} // class UserSeeder extends Seeder {}
