<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (Tenant::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            Tenant::insert([
                [
                    'id' => 1,
                    'uuid' => 'aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa',
                    'active' => 1,
                    'created_at' => $date,
                    'updated_at' => $date,
                    'identifier' => 'System',
                    'master_id' => null,
                ],
            ]);

        }
    } // run()

} // class TenantSeeder extends Seeder {}
