{{--
 * Blade Template
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Blades
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
--}}

    <button aria-label="Toggle dark mode" class="inline-flex items-center p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" id="dark-mode-toggle" type="button">
      <!-- Icon: Sun / Moon (Tailwind classes change via dark:) -->
      <svg id="icon-sun" class="w-6 h-6 block dark:hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v2m0 14v2m9-9h-2M5 12H3m15.36 6.36l-1.42-1.42M7.05 7.05L5.63 5.63m12.72 0l-1.42 1.42M7.05 16.95l-1.42 1.42M12 8a4 4 0 100 8 4 4 0 000-8z"/>
      </svg>
      <svg id="icon-moon" class="w-6 h-6 hidden dark:block" viewBox="0 0 24 24" fill="none" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"d="M21 12.79A9 9 0 1111.21 3 7 7 0 0021 12.79z"/>
      </svg>
    </button>

@push('post-scripts')

    <script>

        document.addEventListener('DOMContentLoaded', function () {
            const btn = document.getElementById('dark-mode-toggle');

            btn?.addEventListener('click', function () {
                try {
                    const isDark = document.documentElement.classList.toggle('dark');
                    localStorage.setItem('theme', isDark ? 'dark' : 'light');

                    // optional: update icons if you used classes instead of CSS variants
                    document.getElementById('icon-sun').style.display = isDark ? 'none' : 'block';
                    document.getElementById('icon-moon').style.display = isDark ? 'block' : 'none';

                } catch (e) {
                    console.error(e);
                }
            });
        });

    </script>

@endpush