<div x-data="createUser" x-cloak x-show="show" id="createUserModal" tabindex="-1"
    x-on:show-create-user-modal.window="showCreateUserModal()" x-on:user-created.window="onUserCreated($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- <x-fkb-font.piktos-normal.user class="text-3xl" /> --}}
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('globals::users.action.create')
                    </h3>
                </div>
                <button x-on:click="hideCreateUserModal" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div>
                        <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('globals::users.field.name')
                            <x-globals::global.input-required-hint />
                        </label>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.addUser" type="text" wire:model="name"
                            id="name"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('globals::users.field.name')" required="">
                            <x-input-error for="name" />
                    </div>
                    <div>
                        <label for="email" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('globals::users.field.email')
                            <x-globals::global.input-required-hint />
                        </label>
                        <input :disabled="createSucceeded" @keyup.enter="$wire.addUser" type="email"
                            wire:model="email" id="email"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('globals::users.field.email')" required="">
                            <x-input-error for="email" />
                    </div>
                </div>

                <div class="inline-flex items-center justify-center w-full">
                    <hr class="w-64 h-px my-8 bg-gray-200 border-0 dark:bg-gray-700">
                    <span class="absolute px-3 font-medium text-gray-900 -translate-x-1/2 bg-white left-1/2 dark:text-white dark:bg-gray-900">
                        {{__('globals::users.section-heading.roles')}}
                    </span>
                </div>

                <div class="justify-around mb-4">
                    @foreach ($roles as $id => $role)
                        <label class="flex cursor-pointer m-2">
                            <input type="checkbox" wire:model="selectedRoles.{{$id}}" value="{{$id}}" class="sr-only peer">
                            <div class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600"></div>
                            <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                {{$role->labels->{app()->getLocale()} ?? 'N/A' }}
                            </span>
                        </label>
                    @endforeach
                </div>
                <div class="flex justify-center">
                    <x-input-error for="selectedRoles" />
                </div>

                <div x-cloak x-show="createSucceeded"
                    class="p-4 mb-4 text-primary-800 border border-primary-300 rounded-lg bg-primary-50 dark:bg-gray-800 dark:text-primary-400 dark:border-primary-800"
                    role="alert">
                    <div class="flex items-center">
                        <svg class="flex-shrink-0 w-4 h-4 me-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                            fill="currentColor" viewBox="0 0 20 20">
                            <path
                                d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                        </svg>
                        <span class="sr-only">
                            @lang('globals::users.info.heading')
                        </span>
                        <h3 class="text-lg font-medium">
                            @lang('globals::users.info.heading')
                        </h3>
                    </div>
                    <div class="mt-2 mb-4 text-sm">
                        @lang('globals::users.info.user-recives-login-details')
                    </div>
                </div>
                <div x-cloak x-show="!createSucceeded" class="flex justify-end">
                    <button wire:loading.remove wire:target="addUser" wire:click="addUser" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg class="w-6 h-6 mr-1 -ml-1" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                        @lang('globals::users.action.create')
                    </button>
                    <x-globals::global.loading-spinner wire:loading wire:target="addUser" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('createUser', () => ({
                show: false,
                createSucceeded: false,

                // CREATE
                onUserCreated(event) {
                    this.createSucceeded = true;
                },
                resetUserCreated() {
                    this.createSucceeded = false;

                    @this.name = null;
                    @this.email = null;
                },
                hideCreateUserModal() {
                    this.show = false;
                    this.resetUserCreated();
                },
                showCreateUserModal(id) {
                    this.show = true;

                    setTimeout(() => {
                        document.getElementById('name').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
