<?php
/**
 * Eloquent Helper Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Helpers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Helpers;


use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;


/**
 * Eloquent Helper Class
 *
 * @version     1.0.0 / 2025-05-29
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EloquentHelper
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection with ID => attribute value based on language code and fallback
     *
     * @param       Builder|string $classOrBuilder
     *              Can be either an instance of Illuminate\Database\Eloquent\Builder or
     *              a fully qualified class name of a model class.
     *
     * @param       string $locale
     *              The desired locale.
     *
     * @param       string $attribute
     *              The name of a Json attribute.
     *
     * @param       null|string $fallbackAttribute = null
     *              If no $fallbackAttribute is passed, then 'id' is used.
     *
     * @param       null|string $fallbackLocale = null
     *              If no $fallbackLocale is passed, then config('app.fallback_locale', 'en')
     *              is used.
     *
     * @return      Collection
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     *
     */
    public static function getLocalizedCollection(Builder|string $classOrBuilder, string $locale, string $attribute, null|string $fallbackAttribute = null, null|string $fallbackLocale = null): Collection
    {
        if ($fallbackLocale === null) {
            $fallbackLocale = config('app.fallback_locale', 'en');
        }
        if ($fallbackAttribute === null) {
            $fallbackAttribute = 'id';
        }
        if ($classOrBuilder instanceof Builder) {
            $Query = $classOrBuilder;
        } else {
            $Query = $classOrBuilder::query();
        }
        return $Query->get()
            ->mapWithKeys(function ($Model) use ($attribute, $fallbackAttribute, $fallbackLocale, $locale) {
                $Names = $Model->{$attribute};
                $name = $Names->{$locale} ?? null;

                if (empty($name)) {
                    $name = $Names->{$fallbackLocale} ?? null;
                }
                return [$Model->id => $name ?? strtolower($Model->{$fallbackAttribute})];
            }
        );
    } // getLocalizedCollection()


} // class EloquentHelper {}
