<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Foundation\Http\Controllers\CoreController;
use BplanBase\Globals\Livewire\Core\EntityTypes\Form as EntityTypeForm;
use BplanBase\Globals\Livewire\Core\EntityTypes\Grid as EntityTypeGrid;
use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Repositories\EntityTypeRepository;
use BplanBase\Globals\Services\EntityTypeService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     2.0.0 / 2025-06-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EntityTypeController extends CoreController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = EntityTypeForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = EntityTypeGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = EntityType::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = EntityTypeRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'entity-types';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       EntityTypeService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, EntityTypeService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EntityTypeController extends CoreController {}
