<?php #CodeGenerator Δ 140b49bd9ba63fdeedcc9f5d59d55442 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-28 04:11:42
 * @package     bplan-base/globals
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Models;


use BplanBase\Globals\Foundation\Database\Eloquent\Models\BaseModel;
use BplanBase\Globals\Observers\EntityTypeObserver;
use BplanBase\Globals\Registries\Registry;
use BplanBase\Globals\Scopes\TenantScope;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanBase\Globals\Traits\HasNoInternalScope;
use BplanBase\Globals\Traits\HasOrderedScope;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.5.0 / 2025-06-28
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([EntityTypeObserver::class])]
class EntityType extends BaseModel
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use HasNoInternalScope;
    use HasOrderedScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $appends = [
        'label',
    ];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $casts = [
        'abstract'        => 'boolean',
        'active'          => 'boolean',
        'creatable'       => 'boolean',
        'created_at'      => 'datetime',
        'deleted_at'      => 'datetime',
        'editable'        => 'boolean',
        'historize'       => 'boolean',
        'internal'        => 'boolean',
        'journalize'      => 'boolean',
        'labels'          => 'object',
        'private'         => 'boolean',
        'require_release' => 'boolean',
        'updated_at'      => 'datetime',
        'visible'         => 'boolean',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $fillable = [
        'abstract',
        'active',
        'creatable',
        'delete_mode',
        'edit_type',
        'editable',
        'historize',
        'html_mask',
        'identifier',
        'internal',
        'journalize',
        'labels',
        'main_type',
        'master_id',
        'model_id',
        'module_id',
        'private',
        'require_release',
        'resource_name',
        'source_id',
        'sub_type',
        'text_mask',
        'visible',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'tenant_id',
        'updated_at',
        'uuid',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-06-28
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'entity_types';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function derivedEntityTypes(): HasMany
    {
        return $this->hasMany(EntityType::class, 'source_id');

    } // derivedEntityTypes()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function fields(): HasMany
    {
        return $this->hasMany(EntityTypeField::class, 'entity_type_id');

    } // fields()


    /**
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getLabelAttribute(): string
    {
        $fallback = config('app.fallback_locale');
        $locale = Registry::get('appLocale');

        return $this->labels->{$locale} ?? ($this->labels->{$fallback} ?? $this->identifier);

    } // getLabelAttribute()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function individuals(): HasMany
    {
        return $this->hasMany(Individual::class, 'entity_type_id');

    } // individuals()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function masterEntityType(): BelongsTo
    {
        return $this->belongsTo(EntityType::class, 'master_id');

    } // masterEntityType()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function model(): BelongsTo
    {
        return $this->belongsTo(EntityTypeModel::class, 'model_id');

    } // model()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function module(): BelongsTo
    {
        return $this->belongsTo(Module::class, 'module_id');

    } // module()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function sourceEntityType(): BelongsTo
    {
        return $this->belongsTo(EntityType::class, 'source_id');

    } // sourceEntityType()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function subEntityTypes(): HasMany
    {
        return $this->hasMany(EntityType::class, 'master_id');

    } // subEntityTypes()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-06-28
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class, 'tenant_id');

    } // tenant()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EntityType extends BaseModel {}
