<?php
/**
 * Registry Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Registries
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Registries;


/**
 * Registry Class
 *
 * @version     1.0.0 / 2025-06-17
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LocationTypeRegistry
{


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $types
     */
    protected static array $types = [
        'Other' => 'Other',
    ];


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function all(): array
    {
        return static::$types;

    } // all()


    /**
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function exists(string $name): bool
    {
        return isset(static::$types[$name]);

    } // exists()


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function names(): array
    {
        ksort(static::$types);

        return array_keys(static::$types);

    } // names()


    /**
     *
     * @param       string $name
     *
     * @param       string|null $label
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function register(string $name): void
    {
        static::$types[$name] = $name;

    } // register()


    /**
     *
     * @return      string|null
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function value(string $name): string|null
    {
        return static::$types[$name] ?? null;

    } // value()


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function values(): array
    {
        sort(static::$types);

        return array_values(static::$types);

    } // values()


} // class LocationTypeRegistry {}
