<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  ViewComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\View\Components\FormElements;


use Closure;


use Illuminate\Support\Collection;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;


/**
 * HTML-Input
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Hidden extends BaseFormElement
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $type
     */
    protected $_type;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new component instance.
     *
     * @param       string $name
     *
     * @param       array $attributes
     *
     * @param       bool|null|string $group
     *
     * @param       bool $noWire
     *
     * @param       string $value
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $name, array $attributes = [],
        public bool|null|string $group = null,
        public string $modifier = '',
        public bool $noWire = false,
        public string $value = ''
    ) {
        $this->_init($name);
        $this->_processAttributes($attributes);

    } // __construct()


    /**
     * Get the view / contents that represent the component.
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render(): View|Closure|string
    {
        $this->_prepareAttributeString();

        return view('globals::components.form-elements.hidden');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // abstract class Hidden extends BaseFormElement {}
