# Globals Configuration

This document describes the configuration settings available in the Globals package.

## Configuration options in alphabetical order

```toml
ANONYMIZATION_THRESHOLD_DAYS =
```

```toml
API_DEFAULT_CLIENT =
```

```toml
API_LOG_LEVEL = 0
```
Sets the level for API logging. Possible settings are:

* 0 = no logging, only in the event of an error
* 1 = notice, minimum log data
* 2 = info, extended log data
* 3 = debug, complete log data

Regardless of the log level set, complete data is always saved in the event of an error. Log files are saved in `storage/logs/api` (one log file per day).

```toml
APP_LAYOUT = globals::layouts.module-frame
```

```toml
CODE_GENERATOR_ACTIVE = true
```
De-/activates the Code Generator. Automatic code generation is deactivated by default.

```toml
CODE_GENERATOR_CREATE_JSONAPI = false
CODE_GENERATOR_CREATE_CSHARP = false
```
The code generator generates files for Laravel, Livewire, JsonApi and C#. The code generator creates files for Laravel, Livewire, JsonApi, and C#. All files are generated by default, but the generation of JsonApi and C# classes can be disabled.
There is currently only one generator for C# NewtonSoft classes. The generated classes are stored in the directory `storage/app/build/CodeGenerator/CSharp/NewtonSoft`.

```toml
CODE_GENERATOR_SKIP_ROUTING = true
```
During development, it may happen that the code generator cannot complete its work due to an error that occurs during migration or seeding. It may then not be possible to run the migration again because the required relations have not been created.
This setting deactivates routing, which means that missing or incorrectly generated files do not trigger any errors. Once the code generator has successfully completed its work, the configuration setting can be removed again or the value can be set to `false`.

```toml
DB_SQL_LOGGING = true
```
Activates SQL logging.

```toml
DEV_SEEDER_CREATE_USER = dev.user@example.com
```
The user associated with the specified email address is entered as a create user when seeding the database. Defaults to the system user.

```toml
GLOBAL_TENANT =
```

```toml
LOG_LEVEL =
```
This is Laravel's default configuration setting `LOG_LEVEL`, which is also used to control logging for the “_AppLog_” class, which is part of the Globals package.
The logs are written to the `storage/logs/app` directory (one log file per day). Log messages from the “_warning_” level upwards are also written to the regular Laravel log.

```toml
PATH_APACHE_BINARY = "/path/to/apache/bin/httpd.exe"
```
Configure the path to the Apache executable. This setting defaults to `/.server/xampp/apache/bin/httpd.exe`.

```toml
PATH_PHP_BINARY = "/path/to/php.exe"
```
Configure the path to the PHP executable. This setting defaults to `/.server/bin/php/8.latest/php.exe`.

