<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanBase\Globals\Enums\UserAccessLevel;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $Table) {
            $Table->dropColumn([
                'tenant_id',
            ]);
        });
    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $Table) {
            $Table->foreignId('tenant_id')->constrained(table: 'tenants', indexName: 'settings_FK_tenant_id')->after('restricted');

            $Table->index('tenant_id',                      'settings_FKI_tenant_id');
            $Table->unique(['tenant_id', 'context', 'key'], 'settings_UKI_tenant_context_key');

            new CodeGenerator($Table, [
                'columns' => [
                    'tenant_id' => [
                        'guarded' => true,
                        'sortable' => true,
                    ],
                ],

            ]);

        });
    } // up()

};
