<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Demo;


use App\Models\User;
use BplanBase\Globals\Enums\UserAccessLevel;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Setup\Logger;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * Seed default demo users with records and roles.
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CombinedUserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $DemoTenant = Tenant::where('identifier', '=', 'DemoTenant')->first();

        $adminPassword = '5qM$K4946P!2he';
        $userPassword = 'Test!234';

        $users = [
            [
                'data' => [
                    'access_level' => UserAccessLevel::SystemManager->name,
                    'email' => 'demo.admin@bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'Demo Admin',
                ],
                'password' => $adminPassword,
                'roles' => [
                    'Admin',
                ],
            ],
            [
                'data' => [
                    'access_level' => UserAccessLevel::Admin->name,
                    'email' => 'demo.user@bplan-solutions.de',
                    'name' => 'Demo User',
                    'tenant_id' => $DemoTenant->id,
                ],
                'password' => $userPassword,
                'roles' => [
                    'Admin',
                ],
            ],
        ];
        // User::insert($users);
        seed_users($users);


    } // run()


} // class CombinedUserSeeder extends Seeder {}
