<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use App\Models\User;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Setup\Logger;
use BplanBase\Globals\Repositories\UserRecordRepository;
use BplanBase\Globals\Repositories\UserRepository;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FinishSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $Tenants = Tenant::get();

        $logStrings = [];

        if (!$Tenants->isEmpty()) {
            foreach ($Tenants as $Tenant) {
                $logStrings[] = 'Tenant #'.$Tenant->id.'/'.$Tenant->uuid.'/'.md5($Tenant->uuid);
            }
        }
        Logger::log($logStrings, __FILE__);

    } // run()

} // class FinishSeeder extends Seeder {}
