<?php
/**
 * Helper Function Library
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Libraries
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

use BplanBase\Globals\Logging\AppLog;


if (!function_exists('app_log_alert')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_alert(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::alert($message, $context, $prefix);

    } // app_log_alert()
}


if (!function_exists('app_log_critical')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_critical(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::critical($message, $context, $prefix);

    } // app_log_critical()
}


if (!function_exists('app_log_debug')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_debug(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::debug($message, $context, $prefix);

    } // app_log_debug()
}


if (!function_exists('app_log_emergency')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_emergency(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::emergency($message, $context, $prefix);

    } // app_log_emergency()
}


if (!function_exists('app_log_error')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_error(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::error($message, $context, $prefix);

    } // app_log_error()
}


if (!function_exists('app_log_info')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_info(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::info($message, $context, $prefix);

    } // app_log_info()
}


if (!function_exists('app_log_notice')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_notice(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::notice($message, $context, $prefix);

    } // app_log_notice()
}


if (!function_exists('app_log_warning')) {

    /**
     *
     * @param       string|Stringable|Throwable $message
     *
     * @param       string|null $prefix
     *
     * @param       array|string $context
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-08-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function app_log_warning(string|\Stringable|\Throwable $message, string|null $prefix = null, array|string $context = []): void
    {
        AppLog::warning($message, $context, $prefix);

    } // app_log_warning()
}
