<?php
/**
 * Copy Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\EntityTypes;


use BplanBase\Globals\Foundation\Actions\BaseAction;
use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Registries\Registry;
use BplanBase\Globals\Repositories\Core\EntityTypeFieldRepository;
use BplanBase\Globals\Services\EntityTypeFieldService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


/**
 * Copy Action Class
 *
 * @version     1.2.0 / 2025-07-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Copy extends BaseAction
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = EntityType::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Kopiert einen EntityType und gibt den neuen EntityType zurück
     *
     * @param       int|string|EntityType $entityType
     *
     * @return      EntityType
     *
     * @version     1.2.0 / 2025-07-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|Model $entityType): Model
    {
        $Source = $this->_resolveModel($entityType);
        $Model = $Source->replicate(['deleted', 'tenant_id', 'uuid']);

        DB::transaction(function () use ($Model, $Source) {
            $rand = Str::random(6);
            /*
            **  Kopie des EntityTypes erstellen und speichern. */
            $Model->abstract = false;
            $Model->master_id = $Source->id;
            $Model->resource_name .= '-'.strtolower($rand);
            $Model->sub_type .= ucfirst(strtolower($rand));
            $Model->tenant_id = Registry::get('auth.tenantId');

            if ($Model->source_id === null) {
                $Model->source_id = $Source->id;
            }
            $Model->save();
            /*
            **  Fields zum EntityType abarbeiten und kopieren. */
            $Fields = EntityTypeFieldRepository::getAllByEntityType($Source);

            $EntityTypeFieldService = new EntityTypeFieldService();

            foreach ($Fields as $Field) {
                $EntityTypeFieldService->copy($Field->id, $Model->id);
            }
        });
        return $Model;

    } // execute()


} // Copy extends BaseAction {}
