<?php
/**
 * Base Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Foundation\Repositories;


use BplanBase\Globals\Helpers\QueryHelper;
use Closure;
use Illuminate\Database\Eloquent\Builder;
use InvalidArgumentException;


/**
 * Base Repository Class
 *
 * @version     2.0.0 / 2025-08-04
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseIndexCollectionRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Builder|Closure|null $ExtendQuery
     *
     * @param       Builder $Query
     *
     * @version     1.0.0 / 2025-08-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _extendQuery(Builder|Closure|null $ExtendQuery, Builder $Query)
    {
        if ($ExtendQuery !== null) {
            /*
            **  Erweiterte Bedingungen (Filter-/Such-Parameter) anwenden. */
            if ($ExtendQuery instanceof Builder) {
                $Query = QueryHelper::applyConditionsFromBuilder($ExtendQuery, $Query);

            } elseif ($ExtendQuery instanceof Closure) {
                $Query = $ExtendQuery($Query);
            }
        }
        return $Query;

    } // _extendQuery()


    /**
     *
     * @param       string $modelClass
     *
     * @param       Builder|Closure|null $ExtendQuery
     *
     * @throws      InvalidArgumentException
     *
     * @return      Builder
     *
     * @version     1.0.0 / 2025-08-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _resolveQuery(string $modelClass, Builder|Closure|null $ExtendQuery = null): Builder
    {
        if ($ExtendQuery === null) {
            $Query = $modelClass::query();

        } else {
            /*
            **  Erweiterte Bedingungen (Filter-/Such-Parameter) anwenden. */
            if ($ExtendQuery instanceof Builder) {
                $Query = $ExtendQuery;

            } elseif ($ExtendQuery instanceof Closure) {
                $Query = $modelClass::query();

                $Query = $ExtendQuery($Query);
            }
        }
        $QueryModel = $Query->getModel();

        if (($QueryModel instanceof $modelClass) === false) {
            throw new InvalidArgumentException('Expected builder for ['.$modelClass.'], got ['.get_class($QueryModel).'].');
        }
        return $Query;

    } // _resolveQuery()


} // class BaseIndexCollectionRepository {}
