<?php
/**
 * Array Helper Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Helpers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Helpers;


/**
 * Array Helper Class
 *
 * @version     1.0.0 / 2025-05-29
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ArrayHelper
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Sortiert die Schlüssel eines Arrays.
     *
     * Die neue Reihenfolge der Schlüssel ergibt sich aus den in $sortOrder
     * angegebenen Werten. Indizies in $sortOrder, die in $array nicht existieren,
     * werden ignoriert. Schlüssel die in $sortOrder nicht definiert sind, werden
     * in ihrer ursprünglichen Reihenfolge hinten angehängt.
     *      Beispiel:
     *          $array = array('rot' => 1, 'schwarz' => 1, 'gold' => 1);
     *          $sortOrder = array('schwarz', 'rot');
     *
     *          ksort_array($array, $sortOrder);
     *
     *      Ergebnis:
     *              array(
     *                  'schwarz' => 1,
     *                  'rot' => 1,
     *                  'gold' => 1,
     *              );
     *
     * @param       array $array
     *
     * @param       array $sortOrder
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     *
     */
    public static function ksortByArray(array & $array, array $sortOrder): void
    {
        $sorted = array();

        foreach ($sortOrder as $key) {
            if (isset($array[$key])) {
                $sorted[$key] = $array[$key];

                unset($array[$key]);
            }
        }
        $array = array_merge($sorted, $array);

    } // ksortByArray()


} // class ArrayHelper {}
