<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Foundation\Http\Controllers\CoreController;
use BplanBase\Globals\Livewire\Core\EntityTypeFields\Form as EntityTypeFieldForm;
use BplanBase\Globals\Livewire\Core\EntityTypeFields\Grid as EntityTypeFieldGrid;
use BplanBase\Globals\Models\EntityTypeField;
use BplanBase\Globals\Repositories\Core\EntityTypeFieldRepository;
use BplanBase\Globals\Services\EntityTypeFieldService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EntityTypeFieldController extends CoreController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = EntityTypeFieldForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = EntityTypeFieldGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = EntityTypeField::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = EntityTypeFieldRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'entity-type-fields';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       EntityTypeFieldService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, EntityTypeFieldService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EntityTypeFieldController extends CoreController {}
