<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Core\UserRecords;


use BplanBase\Globals\Livewire\Core\Global\BaseForm;
use BplanBase\Globals\Repositories\UserRepository;
use BplanBase\Globals\Services\UserService;
use Exception;


/**
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Form extends BaseForm
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         array $main
     *
     * @version     1.0.0 / 2025-05-25
     */
    public $main = [
        'active'     => true,
        'email' => '',
        'firstName' => '',
        'lastName' => '',
    ];


    /**
     * @var     array $user
     */
    public array $user = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUser(): void
    {
        $User = UserRepository::getById($this->MainObject->id);

        $this->user = [$this->MainObject->id => $User->name];

    } // _initUser()


    /**
     * Überschreibt die gleichnamige Methode der Base-Klasse
     *
     * TenantRecords können nur gelöscht werden indem der zugehörige Tenant gelöscht wird. Deshalb
     * muss die Löschung hier mit der TenantService-Klasse durchgeführt werden.
     *
     * @todo        Prüfen warum hier nicht die Methode der Elternklasse verwendet wird.
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete()
    {
        $this->hideModal();

        try {
            $Service = new UserService();

            $Service->delete($this->MainObject->id);

            return redirect()->route($this->getRedirectRoute('Delete'), $this->getRedirectParameters('Delete'));

        } catch (Exception $Exception) {
            $this->_showNotification($Exception->getMessage());
        }
    } // delete()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount(): void
    {
        parent::mount();

        // $this->_initUser();

    } // mount()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Form extends BaseForm {}
