<?php
/**
 * Global Navigation Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Providers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Providers;


use BplanBase\Globals\Repositories\ModuleRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;


/**
 * Global Navigation Service Provider Class
 *
 * @version     1.0.0 / 2025-08-10
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class NavigationServiceProvider extends ServiceProvider
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Bootstrap services
     *
     * @param       Request $Request
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-10
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(Request $Request): void
    {
        /*
        **  Inject module information into every view. */
        View::composer('*', function ($View) use ($Request) {
            $View->with('currentModule', \Registry::get('env.currentModule'))
                ->with('moduleName', \Registry::get('env.moduleName'));
        });
        /*
        **  Inject the module list into the module dashboard view. */
        //  @todo       Hier muss später die Liste der Module des Mandanten verwendet werden.
        View::composer('globals::module-dashboard', function ($View) use ($Request) {
            $View->with('ModuleCollection', ModuleRepository::getAll());
        });
    } // boot()


    /**
     * Register services
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-10
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function register(): void
    {
        //
    } // register()


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class NavigationServiceProvider extends ServiceProvider {}
