<?php
/**
 * Blade Component Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Traits
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Traits;


use Illuminate\Support\Str;


/**
 * Blade Component Trait
 *
 * @version     1.0.1 / 2025-07-22
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
trait WithComboBoxInput
{


    /* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */

    public ?array $comboBoxData;
    public ?array $filteredComboBoxData;


    /* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     *
     * @param       string $itemsKey
     *
     * @param       array $items
     *
     * @return      void
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function setComboBoxData(string $itemsKey, array $items)
    {
        $this->comboBoxData[$itemsKey] = $items;
        $this->filteredComboBoxData[$itemsKey] = $items;
    }

    /**
     *
     * @param       string $itemsKey
     *
     * @param       ?int $excpetIndex
     *
     * @return      void
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function comboBoxDataDeselectAll(string $itemsKey, ?int $excpetIndex = null)
    {
        foreach ($this->comboBoxData[$itemsKey] as $index => $item) {
            if (!is_int($excpetIndex) || $index != $excpetIndex) {
                $this->comboBoxData[$itemsKey][$index]['isSelected'] = false;
            }
        }
    }


    /**
     *
     * @param       array $array
     *
     * @param       $key
     *
     * @param       $value
     *
     * @return      array
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    private function filter_by_key(array $array, $key, $value)
    {
        $filtered = array();

        foreach ($array as $index => $item) {
            if ($item[$key] == $value) {
                $filtered[$index] = $item;
            }
        }
        return $filtered;
    }


    /**
     *
     * @param       string $itemsKey
     *
     * @param       string $search
     *
     * @return      void
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function filterComboBoxData(string $itemsKey, string $search)
    {
        if (!empty($search)) {
            $this->filteredComboBoxData[$itemsKey] = array_filter($this->comboBoxData[$itemsKey], function($item) use($search) {
                if (Str::contains($item['label'], $search, true)) {
                    return $item;
                }
            });
        } else {
            $this->filteredComboBoxData[$itemsKey] = $this->comboBoxData[$itemsKey];
        }
    }


    /**
     *
     * @param       string $itemsKey
     *
     * @param       string $attr
     *
     * @param       string $value
     *
     * @param       bool $selected
     *
     * @return      void
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function setComboBoxDataItemSelectedByAttr(string $itemsKey, string $attr, string $value, bool $selected = true)
    {
        $foundItems = $this->filter_by_key($this->comboBoxData[$itemsKey], $attr, $value);

        $id = array_key_first($foundItems);

        if ($id === null) {
            $id = $value['id'] ?? null;
        }
        $this->comboBoxData[$itemsKey][array_key_first($foundItems)]['isSelected'] = $selected;
    }


    /**
     *
     * @param       string $itemsKey
     *
     * @param       int $index
     *
     * @param       bool $multiple
     *
     * @return      void
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function toggleComboBoxDataItem(string $itemsKey, int $index, bool $multiple = true)
    {
        $isSelected = $this->comboBoxData[$itemsKey][$index]['isSelected'] ?? null;

        if (!$multiple) {
            $this->comboBoxDataDeselectAll($itemsKey, $index);
        }
        $this->comboBoxData[$itemsKey][$index]['isSelected'] = isset($isSelected) ? !$isSelected : true;
    }


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // trait WithComboBoxInput {}
