<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  ViewComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\View\Components\FormElements;


use Closure;


use Illuminate\Support\Collection;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;


/**
 * HTML-Input
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
abstract class BaseFormElement extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_attributeStrings
     */
    protected $_attributeStrings = [];


    /**
     * @var     string $attributeString
     */
    public $attributeString;


    /**
     * @var     string $classAddition
     */
    public $classAddition = '';


    /**
     * @var     string $id
     */
    public $id;


    /**
     * @var     string $mandatoryMarker
     */
    public $mandatoryMarker;


    /**
     * @var     string $name
     */
    public $name;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $name
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(string $name): void
    {
        $this->id = $name;
        $this->name = $name;

        if ($this->group === null || $this->group === true) {
            $this->group = 'main.';

        } elseif ($this->group !== false) {
            if ($this->group[strlen($this->group) - 1] !== '.') {
                $this->group .= '.';
            }
        }
        if (!empty($this->mandatory)) {
            $this->mandatoryMarker = __('globals::global.required-marker');
        }
        if ($this->modifier !== '') {
            if ($this->modifier[0] !== '.') {
                $this->modifier = '.'.$this->modifier;
            }
        }
    } // _init()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareAttributeString()
    {
        ksort($this->_attributeStrings);

        $this->attributeString = ' '.implode(' ', $this->_attributeStrings);

    } // _prepareAttributeString()


    /**
     *
     * @param       array $attributes
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processAttributes(array $attributes): void
    {
        if (!empty($attributes)) {
            foreach ($attributes as $attribute => $value) {
                $attribute = strtolower($attribute);

                if ($attribute === 'class' || $attribute === 'id' || $attribute === 'name' || $attribute === 'type' || $attribute === 'wire') {
                    continue;
                }
                $this->_attributeStrings[$attribute] = $attribute.'="'.$value.'"';
            }
            if (isset($attributes['class'])) {
                $this->classAddition .= ' '.$attributes['class'];
            }
        }
        if (isset($attributes['id'])) {
            $this->_attributeStrings['id'] = 'id="'.$attributes['id'].'"';
        } else {
            $this->_attributeStrings['id'] = 'id="'.$this->id.'"';
        }
        $this->_attributeStrings['name'] = 'name="'.$this->name.'"';

        if (isset($this->disabled) && $this->disabled === true) {
            $this->_attributeStrings['disabled'] = 'disabled="disabled"';
        }
        if (!isset($this->noWire) || $this->noWire === false) {
            $this->_attributeStrings['wire'] = 'wire:model'.$this->modifier.'="'.$this->group.$this->name.'"';

        } elseif (isset($attributes['wire'])) {
            $this->_attributeStrings['wire'] = $attributes['wire'];
        }
        if (isset($this->readOnly) && $this->readOnly === true) {
            $this->_attributeStrings['disabled'] = 'disabled="disabled"';
            $this->_attributeStrings['readonly'] = 'readonly="readonly"';

            $this->classAddition .= ' readOnly';
        }
    } // _processAttributes()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BaseFormElement extends Component {}
