<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Enums\UserAccessLevel;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * Seed default system users with records and roles.
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CombinedUserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');
        $env = strtolower(config('app.env'));

        $Tenant = Tenant::where('identifier', 'System')->first();

        $users = [
            [
                'data' => [
                    'access_level' => UserAccessLevel::System->name,
                    'email' => 'system@core.bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'system',
                ],
                'password' => false,
                'roles' => null,
            ], [
                'data' => [
                    'access_level' => UserAccessLevel::Developer->name,
                    'email' => 'developer@core.bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'developer',
                ],
                'password' => true,
                'roles' => [
                    'Admin',
                ],
            ], [
                'data' => [
                    'access_level' => UserAccessLevel::Maintainer->name,
                    'email' => 'maintainer@core.bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'maintainer',
                ],
                'password' => true,
                'roles' => [
                    'Admin',
                ],
            ], [
                'data' => [
                    'access_level' => UserAccessLevel::Guest->name,
                    'email' => 'guest@core.bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'guest',
                ],
                'password' => false,
                'roles' => null,
            ],
        ];
        seed_users($users);

    } // run()


} // class CombinedUserSeeder extends Seeder {}
