<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DatabaseSeeder extends Seeder
{


    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $env = strtolower(config('app.env'));

        $seeds = [];

        $seeds = [
            RegisterModuleSeeder::class,
            CountrySeeder::class,
            ExternalSystemSeeder::class,
            CombinedTenantSeeder::class,
            LanguageSeeder::class,
            CombinedUserSeeder::class,
            LocationTypeSeeder::class,

        ];
        if ($env === 'production') {
            //
        } elseif (str_starts_with($env, 'demo') === true) {
            $seeds[] = Demo\CombinedTenantSeeder::class;
            $seeds[] = Demo\CombinedUserSeeder::class;
            $seeds[] = Dev\CombinedUserSeeder::class;

        } else {
            $seeds[] = Dev\CombinedUserSeeder::class;
            $seeds[] = Dev\TenantExternalSystemSeeder::class;
        }
        /*
        **  EntityTypes seeden
        **
        **  Individual          -   Model, EntityType und Fields seeden. */
        $seeds[] = EntityTypes\IndividualModelSeeder::class;
        $seeds[] = EntityTypes\IndividualSeeder::class;
        $seeds[] = EntityTypes\IndividualFieldSeeder::class;
        /*
        **  Individual.Employee -   EntityType und Fields seeden. */
        // $seeds[] = EntityTypes\IndividualEmployeeSeeder::class;
        // $seeds[] = EntityTypes\IndividualEmployeeFieldSeeder::class;

        if ($env === 'production') {
            //
        } elseif (str_starts_with($env, 'demo') === true) {
            //
        } else {
            /*
            **  Individual.Employee -   Daten seeden. */
            $seeds[] = EntityTypes\IndividualEmployeeSeeder::class;
            $seeds[] = EntityTypes\IndividualEmployeeFieldSeeder::class;
            $seeds[] = Dev\EntityTypes\IndividualEmployeeDataSeeder::class;
        }
        $this->call($seeds);

    } // run()


} // class DatabaseSeeder extends Seeder
