<?php
/**
 * Helper Function Library
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Libraries
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;


if (!function_exists('decrypt_env')) {

    /**
     *
     * @param       string $key
     *
     * @param       mixed $default
     *
     * @return      mixed
     *
     * @version     1.0.0 / 2025-08-14
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function decrypt_env(string $key, mixed $default = null)
    {
        $value = env($key, $default);

        if (!$value) {
            return $default;
        }
        if (Str::startsWith($value, '*')) {
            $plainPassword = ltrim($value, '*');
            /*
            **  Vershlüsseln und aktualisieren. */
            $encrypted = Crypt::encryptString($plainPassword);

            update_env_value($key, $encrypted);

            return $plainPassword;
        }
        try {
            return Crypt::decryptString($value);

        } catch (\Exception $E) {
            return $default;
        }
    } // decrypt_env()
}


if (!function_exists('env_to_array')) {

    /**
     *
     * @param       string $key
     *
     * @param       string $values
     *
     * @param       string $separator
     *
     * @version     1.0.0 / 2025-08-24
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function env_to_array(string $key, string $separator = ',')
    {
        $values = env($key, null);

        if ($values === null || trim($values) === '') {
            return [];
        }
        $values = explode($separator, trim($values));

        return array_map(function ($value) {
            return trim($value);

        }, $values);

    } // env_to_array()
}


/**
 * Hilfsfunktion zum Aktualisieren von .env-Werten
 */
if (!function_exists('update_env_value')) {

    /**
     *
     * @param       string $key
     *
     * @param       mixed $value
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-14
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function update_env_value(string $key, mixed $value)
    {
        $envPath = base_path('.env');

        if (!file_exists($envPath)) {
            return;
        }
        $envContent = file_get_contents($envPath);
        /*
        **  Vorhandenen Wert (mit oder ohne Leerzeichen) finden. */
        $pattern = '/^'.$key.'\s*=\s*.*/m';

        if (preg_match($pattern, $envContent)) {
            /*
            **  Vorhandenen Wert ersetzen. */
            $envContent = preg_replace(
                $pattern,
                $key.' = '.$value,
                $envContent
            );
        } else {
            /*
            **  Neuen Wert hinzufügen. */
            $envContent .= "\n".$key.' = '.$value;
        }
        file_put_contents($envPath, $envContent);

    } // update_env_value()
}
