<?php
/**
 * Helper Function Library
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Libraries
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;


if (!function_exists('svg_icon')) {

    /**
     *
     * @param       string $configKey
     *
     * @param       array $attributes
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-08-10
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    function svg_icon(string $configKey, string|null $attributes = null): string|null
    {
        $svg = config($configKey, null);

        if ($svg === null) {
            return null;
        }
        return str_replace(':attributes', $attributes, $svg);

    } // svg_icon()
}
