<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Dev;


use App\Models\User;
use BplanBase\Globals\Enums\UserAccessLevel;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Setup\Logger;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * Seed development users with records and roles.
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CombinedUserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');
        $env = strtolower(config('app.env'));

        $Tenant = Tenant::where('identifier', 'System')->first();

        $users = [
            [
                'data' => [
                    'access_level' => UserAccessLevel::Developer->name,
                    'email' => 'emilio.cannarozzo@bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'Emilio Cannarozzo',
                ],
                'password' => true,
                'roles' => [
                    'Admin',
                ],

            ], [
                'data' => [
                    'access_level' => UserAccessLevel::Developer->name,
                    'email' => 'wassilios.meletiadis@bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'Wassilios Meletiadis',
                ],
                'password' => true,
                'roles' => [
                    'Admin',
                ],
            ], [
                'data' => [
                    'access_level' => UserAccessLevel::Developer->name,
                    'email' => 'tolga.kocer@bplan-solutions.de',
                    'internal' => 1,
                    'name' => 'Tolga Kocer',
                ],
                'password' => true,
                'roles' => [
                    'Admin',
                ],

            ],
        ];
        seed_users($users);

    } // run()


} // class CombinedUserSeeder extends Seeder {}
