{{--
 * Blade Template
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Blades
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
--}}

    <div>
      <button aria-controls="default-sidebar" class="inline-flex items-center p-2 mt-2 ml-3 text-sm text-gray-500 rounded-lg sm:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600" data-drawer-target="default-sidebar" data-drawer-toggle="default-sidebar" type="button">
        <span class="sr-only">Open sidebar</span>
        <svg aria-hidden="true" class="size-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
          <path clip-rule="evenodd" fill-rule="evenodd" d="M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm0 10.5a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10z"></path>
        </svg>
      </button>

      <aside aria-label="Sidenav" class="fixed top-0 left-0 z-30 w-64 h-screen transition-transform -translate-x-full sm:translate-x-0" id="default-sidebar">
        <div class="pb-24 overflow-y-auto py-5 px-3 h-full bg-white border-r border-gray-200 dark:bg-gray-800 dark:border-gray-700">
          <!-- Logo -->
          <div class="flex items-center shrink-0 mb-4 pl-2">
            <a href="{{ route('dashboard') }}">
              <x-application-mark class="block w-auto h-9 invisible" />
            </a>
          </div>

          <ul class="nav flex-column space-y-2 pt-2">

@foreach($sidebarMenuItems as $Item)
    @if($Item->hasChildren())

            <li>
              <button aria-controls="dropdown-pages" class="flex items-center p-2 w-full text-base font-normal text-gray-900 rounded-lg transition duration-75 group hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700" data-collapse-toggle="dropdown-pages" type="button">
                {!! $Item->icon !!}

                <span class="flex-1 ml-3 text-left whitespace-nowrap">{{ $Item->label }}</span>
                <svg aria-hidden="false" class="size-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                  <path clip-rule="evenodd" fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"></path>
                </svg>
              </button>

              <ul class="{!! $Item->active ? '' : 'hidden ' !!} py-2 space-y-2" id="dropdown-pages">

        @foreach($Item->children as $Child)

                <li class="flex items-center justify-between">
                  <a href="{{ $Child->url }}" class="flex flex-1 mr-2 items-center p-2 pl-11 w-full text-base font-normal text-gray-900 rounded-lg transition duration-75 group hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700">
                    {{ $Child->label }}
                  </a>
                  <span{{ $Child->active ? '' : ' x-cloak' }} x-show="{{ $Child->active ? 'true' : 'false' }}" class="w-1 min-h-6 rounded bg-white-400 transition duration-75 dark:bg-gray-400 group-hover:bg-gray-900 dark:group-hover:bg-white"></span>
                </li>

        @endforeach

              </ul>
              <hr class="my-4">
            </li>

    @else

            <li class="flex items-center justify-between">
              <a href="{{ $Item->url }}" class="flex flex-1 mr-2 items-center p-2 text-base font-normal text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 group">
                {!! $Item->icon !!}
                <span class="ml-3 overflow-hidden text-ellipsis max-w-40">{{ $Item->label }}</span>
              </a>
              <span class="w-1 min-h-6 rounded bg-white-400 transition duration-75 dark:bg-gray-400 group-hover:bg-gray-900 dark:group-hover:bg-white"{{ $Item->active ? '' : ' x-cloak' }} x-show="{{ $Item->active ? 'true' : 'false' }}"></span>
            </li>

    @endif
@endforeach

          </ul>
        </div>
      </aside>
    </div>