{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Templates
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
--}}

          <div class="grid grid-cols-6 sm:grid-cols-6 gap-6 min-w-full pl-6 pr-6 p-4">
            <div class="col-span-3 sm:col-span-3 flex items-center text-sm">
              {!!__('globals::global.required-hint', ['marker' => __('globals::global.required-marker')])!!}
            </div>
            <div class="col-span-3 sm:col-span-3">
              <div class="flex justify-end">
                <a href="{!! route($this->getRedirectRoute('Abort'), $this->getRedirectParameters('Abort')) !!}">
                  <button class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" onfocus="this.blur();" title="{!! __('globals::global.action.back') !!}" type="button">{!! __('globals::global.action.back') !!}</button>
                </a>

@if ($readOnly === false)
    @if ($mainID !== null)

                <button class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500" onfocus="this.blur();" title="{!! __('globals::global.action.delete') !!}" type="button" wire:click="confirmDelete">{!! __('globals::global.action.delete') !!}</button>

    @endif

    @if ($multiSaveButton === true)

                <button class="ml-3 inline-flex justify-center py-2 pl-1 pr-0 border border-transparent shadow-sm text-sm font-medium rounded-md rounded-r-none text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" onfocus="this.blur();" title="{!! __('globals::global.action.save-and-back') !!}" type="button" wire:click="save(true)">
                  <svg class="size-5" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15.75 19.5 8.25 12l7.5-7.5" stroke-linecap="round" stroke-linejoin="round" />
                  </svg>
                </button>
                <button class="inline-flex justify-center py-2 px-4 pl-1 border border-transparent shadow-sm text-sm font-medium rounded-md rounded-l-none text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" onfocus="this.blur();" title="{!! __('globals::global.action.save') !!}" type="button" wire:click="save">{!! __('globals::global.action.save') !!}</button>

    @else

                <button class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" onfocus="this.blur();" title="{!! __('globals::global.action.save') !!}" type="button" wire:click="save">{!! __('globals::global.action.save') !!}</button>

    @endif
@endif

@if ($additionalButtons !== null)
    @foreach ($additionalButtons as $additionalButton)
        @include('globals::livewire.core.'.$resourceName.'.form-snippets.'.$additionalButton.'-button')

    @endforeach


@endif

              </div>
            </div>
          </div>
