{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Views
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 --}}

        <div x-data="{ open: false }" class="relative">
            <label class="invisible">
                @lang('globals::global.sorting.heading')
            </label>
            <!-- Button -->
            <button
                @click="open = !open"
                class="flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-gray-900 dark:text-gray-100 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg md:w-auto focus:outline-none hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700"
                type="button"
            >
                <svg aria-hidden="true" class="w-5 h-5 mr-2 text-gray-400" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M8 17V7" />
                    <path d="M8 7l-3 3" />
                    <path d="M8 7l3 3" />
                    <path d="M16 7v10" />
                    <path d="M16 17l-3-3" />
                    <path d="M16 17l3-3" />
                </svg>
                <span>

@if (empty($selectedColumn))

    {{ __('globals::global.sorting.heading') }}

@else

    {{ $columns[$selectedColumn] ?? '' }} ({{ $direction === 'asc' ? __('globals::global.sorting.direction.ascending') : __('globals::global.sorting.direction.descending') }})

@endif

                </span>
                <svg aria-hidden="true" class="-mr-1 ml-1.5 w-5 h-5" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path clip-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" fill-rule="evenodd" />
                </svg>
            </button>

            <!-- Dropdown Panel -->
            <div x-show="open" x-cloak @click.away="open = false" class="absolute mt-2 w-48 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg shadow-lg z-50">
                <!-- Spaltenauswahl -->
                <div class="py-2">
                    <button
                        wire:click="setColumn('')"
                        @click="open = false"
                        class="w-full flex justify-between items-center px-3 py-2 text-sm hover:bg-gray-100 dark:hover:bg-gray-700 {{ empty($selectedColumn) ? 'bg-gray-50 dark:bg-gray-700 font-semibold' : '' }}"
                        type="button"
                    >
                        <span>{{ __('globals::global.sorting.no-sorting') }}</span>
                    </button>

@foreach($columns as $key => $label)

                    <button
                        wire:click="setColumn('{{ $key }}')"
                        @click="open = false"
                        class="w-full flex justify-between items-center px-3 py-2 text-sm hover:bg-gray-100 dark:hover:bg-gray-700 {{ $selectedColumn === $key ? 'bg-gray-50 dark:bg-gray-700 font-semibold' : '' }}"
                        type="button"
                    >
                        <span>{{ $label }}</span>

    @if($selectedColumn === $key)

                        <svg class="h-4 w-4 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                            <path clip-rule="evenodd" d="M16.704 5.29a1 1 0 010 1.42l-7.071 7.071a1 1 0 01-1.42 0L3.296 9.845a1 1 0 011.42-1.42l3.91 3.91 6.361-6.362a1 1 0 011.417.002z" fill-rule="evenodd" />
                        </svg>

    @endif

                    </button>

@endforeach

                </div>

                <hr class="my-1 border-gray-200 dark:border-gray-700" />

                <!-- Sortierrichtung -->
                <div class="py-2">
                    <button
                        wire:click="setDirection('asc')"
                        @click="open = false"
                        class="w-full flex justify-between items-center px-3 py-2 text-sm hover:bg-gray-100 dark:hover:bg-gray-700 {{ !empty($selectedColumn) && $direction === 'asc' ? 'bg-gray-50 dark:bg-gray-700 font-semibold' : '' }}"
                        type="button"
                    >
                        {{ __('globals::global.sorting.direction.ascending') }}

@if(!empty($selectedColumn) && $direction === 'asc')

                        <svg class="h-4 w-4 text-green-500" viewBox="0 0 20 20" fill="currentColor">
                            <path clip-rule="evenodd" d="M16.704 5.29a1 1 0 010 1.42l-7.071 7.071a1 1 0 01-1.42 0L3.296 9.845a1 1 0 011.42-1.42l3.91 3.91 6.361-6.362a1 1 0 011.417.002z" fill-rule="evenodd" />
                        </svg>

@endif

                    </button>
                    <button
                        wire:click="setDirection('desc')"
                        @click="open = false"
                        class="w-full flex justify-between items-center px-3 py-2 text-sm hover:bg-gray-100 dark:hover:bg-gray-700 {{ !empty($selectedColumn) && $direction === 'desc' ? 'bg-gray-50 dark:bg-gray-700 font-semibold' : '' }}"
                        type="button"
                    >
                        {{ __('globals::global.sorting.direction.descending') }}

@if(!empty($selectedColumn) && $direction === 'desc')

                        <svg class="h-4 w-4 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                            <path clip-rule="evenodd" d="M16.704 5.29a1 1 0 010 1.42l-7.071 7.071a1 1 0 01-1.42 0L3.296 9.845a1 1 0 011.42-1.42l3.91 3.91 6.361-6.362a1 1 0 011.417.002z" fill-rule="evenodd" />
                        </svg>

@endif

                    </button>
                </div>
            </div>
        </div>
